function TRACKS=simulation_motions(N, L, tau, D, name) 
  % N=50;
  count=1;
  
  t=[1:L];
  v=1:50;
  Z= 50.*randn(2,N);
  sigma=1;
  q=sqrt(2*D*tau);
  switch name
      
      case 'brownian'
          
          for k=1:N
              X=Z(:,k);
              for i = 1:length(t)-1
                  %X(:,i+1) = X(:,i)+q.*randn(2,1);
                  X(:,i+1) = X(:,i)+sigma.*randn(2,1);
              end
              TRACKS(k).coord = [X(1,:); X(2,:)];
              TRACKS(k).times=[1:L];
              TRACKS(k).orig = k;
              TRACKS(k).surf=zeros(1,L);
              TRACKS(k).int=zeros(1,L);  
              fig=figure(count);
              hold on
              plot(X(1,:),- X(2,:))
          end
          namefile = ['./RESULTS/browinan_tracks.eps'];
          saveas(fig, namefile);
          print('-depsc', namefile);
          count=count+1;
          
          
      case 'directed'
          for k=1:N
              %mu =randn(2,1);
              %sigma=8.*norm(mu,2)/11;
              v=2.0;
              X=Z(:,k);
              for i = 1:length(t)-1
                  %X(:,i+1) = X(:,i)+mu+sigma*randn(2,1);
                  X(:,i+1) = X(:,i)+v+sigma*randn(2,1);
              end
              TRACKS(k).coord = [X(1,:); X(2,:)];
              TRACKS(k).times=[1:max(t)];
              TRACKS(k).orig = k;
              TRACKS(k).surf=zeros(1,max(t));
              TRACKS(k).int=zeros(1,max(t));
              fig=figure(count);
              hold on
              plot(X(1,:),- X(2,:))
          end
          namefile = ['./RESULTS/directed_tracks.eps'];
          saveas(fig, namefile);
          print('-depsc', namefile);
          count=count+1;
          
          
      case 'confined'
          
          for k=1:N
              
              %
              % th = 30;
              % mu = 1.2;
              % sig = 0.3;
              % dt = 1e-2;
              % t = 0:dt:29*dt;             % Time vector
              % X = zeros(2,length(t));
              % X(:,1) = Z(:,k);% Allocate output vector, set initial condition
              % rng(1);                 % Set random seed
              % for i = 1:length(t)-1
              %     X(:,i+1) = X(:,i)+th*(mu-X(:,i))*dt+sig*sqrt(dt)*randn(2,1);
              % end
              
              
              %lambda=1.0;
              %mu=ones(2,1);
              lambda=1.0;
              mu=zeros(2,1);
              %X=Z(:,k);              
              X=mu;
              for i = 1:length(t)
                  X(:,i+1) = X(:,i)+lambda*(mu-X(:,i))+sigma*randn(2,1);                  
              end
              X=X+repmat(X(:,1), 1,length(t)+1);
              X(:,1)=[];
              TRACKS(k).coord = [X(1,:); X(2,:)];
              TRACKS(k).times=[1:max(t)];
              TRACKS(k).orig = k;
              TRACKS(k).surf=zeros(1,max(t));
              TRACKS(k).int=zeros(1,max(t));
              fig=figure(count);
              hold on
              plot(X(1,:), -X(2,:))
          end
          namefile = ['./RESULTS/confined_tracks.eps'];
          saveas(fig, namefile);
          print('-depsc', namefile);
          count=count+1;
  end
   
end